% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_groups.R
\name{data_diff_groups}
\alias{data_diff_groups}
\title{Add diff_groups results as columns in a data frame}
\usage{
data_diff_groups(
  data,
  input_vars,
  output_vars = c(is_common = "is_common", diff_1_2 = "diff_1_2", diff_2_1 = "diff_2_1",
    sum_1_2 = "sum_1_2", sum_2_1 = "sum_2_1"),
  ...
)
}
\arguments{
\item{data}{A data frame containing the variables to be compared.}

\item{input_vars}{Character vector of length two specifying the names of the two
variables in \code{data} to be compared.}

\item{output_vars}{Named character vector defining which variables from the group
results are added to \code{data}, and what their names will be in the output.}

\item{...}{Additional arguments passed to \code{\link[=diff_groups]{diff_groups()}}.}
}
\value{
A data frame identical to \code{data}, but with additional variables describing
relationships between the two specified columns.
}
\description{
\code{data_diff_groups()} is a wrapper around \code{\link[=diff_groups]{diff_groups()}} that runs the same analysis
on two variables in a data frame and adds selected results back as new columns.
}
\examples{
df <- cbind(v1 = 1, SSBtoolsData("code_pairs"), v4 = 4)

data_diff_groups(df, input_vars = c("code_1", "code_2"))

}
