% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_NMR.R
\name{plot_NMR}
\alias{plot_NMR}
\title{NMR Plotting Function}
\usage{
plot_NMR(
  raw.spec,
  NMRmeth = NULL,
  use.tiff = NULL,
  set.plot.ymax = NULL,
  file.output = NULL
)
}
\arguments{
\item{raw.spec}{loaded NMR spectra}

\item{NMRmeth}{Regions to be integrated, methods available include: "4region", "Bonanomi", "Smernik" and Molecular mixing model ("MMM").}

\item{use.tiff}{Logical, default to FALSE (use png)}

\item{set.plot.ymax}{Set maximum of plot y axis, defaults to NULL}

\item{file.output}{Logical, default to FALSE}
}
\value{
A plot of the NMR spectrum and a  csv file of the data plotted.
}
\description{
This function allows you to plot the 13C-NMR spectra using marking different integration regions.
The loaded Raw spectra are intensity normalized and plotted with the chosen integration regions, either spinning side bands (default),
the Bonanomi("Bonanomi") regions or the Molecular Mixing Model regions("MMM").
The function returns the plots as images either tiff or png, normalized and flattened spectrum
}
\examples{
\donttest{
library(ggplot2)
data("GarciaF200")
plot_NMR(GarciaF200, NMRmeth = "MMM", file.output = FALSE, use.tiff = FALSE)
}
}
\keyword{integration}
\keyword{normalization}
