% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silhouette.profile.R
\name{silhouette.profile}
\alias{silhouette.profile}
\title{Silhouette profile}
\usage{
silhouette.profile(
  SOM,
  Nclus,
  dist_clust = "euclidean",
  clust_method = "complete"
)
}
\arguments{
\item{SOM}{the SOM object to cluster}

\item{Nclus}{the cluster number on which the silhouette profile will be computed}

\item{dist_clust}{the metric for the distance calculation}

\item{clust_method}{the method for the clustering (passed to the hclust function}
}
\value{
A vector of silhouette profile computed with the cluster package
}
\description{
Function to compute the silhouette profile for the Nclus cluster of the SOM neurons
}
\examples{
#Read example SOM data
som_model <- readRDS(system.file("extdata", "SOM_HIFa.rds", package = "SOMMD"))
#Compute the silhouette profile
sil_pro <- silhouette.profile(som_model, Nclus=5, clust_method="complete")

}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
