% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UnivariateObtainQuantileDistribution.R
\name{getQuantile}
\alias{getQuantile}
\title{Obtain Quantile from Distribution Function}
\usage{
getQuantile(
  Ftheta,
  mu,
  sigma,
  dist,
  par.location = 0,
  par.scale = 1,
  par.shape = 1,
  dist.par = NULL
)
}
\arguments{
\item{Ftheta}{scalar. Quantile of the data distribution. The values that take are between (0,1).}

\item{mu}{scalar. Expected value of the desired distribution.}

\item{sigma}{scalar. Standard deviation of the desired distribution.}

\item{dist}{character string. Select from:
\itemize{
  \item{"Uniform: Continuous Uniform distribution .}
  \item{"Normal": Normal distribution (default).}
  \item{"Normal2": Squared Normal distribution (also known as Chi-squared).}
  \item{"DoubleExp": Double exponential distribution (also known as Laplace distribution).}
  \item{"DoubleExp2": Double exponential squared distribution from a \code{DoubleExp(0,1)}.}
  \item{"LogNormal": Lognormal distribution.}
  \item{"Gamma": Gamma distribution.}
  \item{"Weibull": Weibull distribution.}
  \item{"t": Student-t distribution.}
}}

\item{par.location}{scalar. Location parameter of the desired distribution. Default 0**.}

\item{par.scale}{scalar. Scale parameter of the desired distribution. Default 1**.}

\item{par.shape}{scalar. Shape parameter of the desired distribution, Default 1.}

\item{dist.par}{vector. Overwrite \code{par.location}, \code{par.scale}, \code{par.shape}. Depends on the distribution (default \code{NULL}):
\itemize{
  \item{"Uniform: no matter how is defined always gives numbers between 0 and 1.}
  \item{"Normal": c(location, scale).}
  \item{"Normal2": c(location, scale).}
  \item{"DoubleExp": c(location, scale).}
  \item{"DoubleExp2": c(location, scale).}
  \item{"LogNormal": c(location, scale).}
  \item{"Gamma": c(scale, shape).}
  \item{"Weibull": c(shape, scale).}
  \item{"t": c(degrees of freedom).}
}}
}
\value{
A quantile \code{theta} of the selected \code{Ftheta} distribution with its parameters.
}
\description{
Get the quantile \code{theta} from several distributions with user defined mean and variance.
}
\examples{
getQuantile(0.5, 0, 1, "Normal")
}
