% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.SLRMss.R
\name{plot.SLRMss}
\alias{plot.SLRMss}
\title{Diagnostic plots for SLRMss objects}
\usage{
\method{plot}{SLRMss}(
  x,
  H0 = FALSE,
  xlab = c("Fitted Values", "Index", "Theoretical Quantiles", "Standardized Residuals"),
  ylab = c("Standardized Residuals", "Standardized Residuals", "Standardized Residuals",
    "Density"),
  main = c("Residuals Against Fitted Values", " Residuals Against Index",
    "Normal Q-Q Plot", "Density Estimate"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{SLRMss}.}

\item{H0}{If TRUE, plot the graphics under null hypothesis, if FALSE, plot the graphics under alternative hypothesis (default).}

\item{xlab}{A vector containing the four x-axis titles.}

\item{ylab}{A vector containing the four y-axis titles.}

\item{main}{A vector containing the four main plot titles.}

\item{...}{Currently ignored.}
}
\value{
Four diagnostic plots extracted from a SLRMss object.
}
\description{
This function provides four plot for residual analysis. The first plot shows the standardized residuals against the fitted values. The second one shows the standardized residuals against by their index. The third one presents QQ-normal plot of them and the last one shows their density estimate.
}
\examples{
data(orange)
fit <- SLRMss(emulsion ~ arabicgum + xanthangum + orangeoil, family="Student",
xi=3, testingbeta="xanthangum", statistic="LR", data=orange)
plot(fit)
}
