% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenotype_IBD_correlation.R
\name{phenotype_IBD_correlation}
\alias{phenotype_IBD_correlation}
\title{Phenotype-IBD correlation}
\usage{
phenotype_IBD_correlation(
  df = NULL,
  rel.df = NULL,
  id.var = NULL,
  rid.vars = NULL,
  ibd.var = NULL,
  pheno.vars = NULL
)
}
\arguments{
\item{df, rel.df}{Data frame}

\item{id.var, ibd.var}{Strings}

\item{pheno.vars, rid.vars}{Character vectors}
}
\value{
Correlation
}
\description{
This function first calculates the correlation between phenotypes
for sample pairs. Then it calculates the correlation between the
phenotype correlation and identity-by-descent for the sample pairs.
(N.B., Please omit missing values before running this function.)
}
\details{
The function requires the following inputs:

1) A sample-by-variable data frame with sample ID and phenotypes.
Columns should include an individual ID variable and phenotype names.

2) A string identifying the ID variable name (e.g., id.var="ID").

3) A vector of phenotype names.
(e.g., pheno.vars=c("PHENO1","PHENO2",...)).

4) A relatedness data frame containing identity-by-descent (IBD) for
pairs of individuals in the sample-by-variable data frame
Column names should include two ID variables and an IBD variable.

5) A vector of the 2 ID variable names in the relatedness data frame.
(e.g., rid.vars=c("ID1","ID2")).

6) A string identifying the IBD variable name (e.g., ibd.var="PropIBD").
}
\examples{
\donttest{
phenotype_IBD_correlation(df = sipPair_exampleData,
rel.df = sipPair_relatednessData, id.var = "IID",
rid.vars = c("IID1","IID2"), ibd.var = "PropIBD",
pheno.vars = paste0("PHENO",1:300))}

phenotype_IBD_correlation(df = sipPair_exampleData[
sipPair_exampleData$IID \%in\% unlist(sipPair_relatednessData[1:100,c("IID1",
"IID2")]),], rel.df = sipPair_relatednessData[1:100,], id.var = "IID",
rid.vars = c("IID1","IID2"), ibd.var = "PropIBD",
pheno.vars = paste0("PHENO",1:300))

}
