% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplicativeMatrix.R
\name{multiplicativeMatrix}
\alias{multiplicativeMatrix}
\title{Generate an multiplicative approximation of a data matrix}
\usage{
multiplicativeMatrix(mat)
}
\arguments{
\item{mat}{A numeric matrix with values to approximate.}
}
\value{
A numeric matrix of the same size as \code{mat}, containing the fitted values.
}
\description{
Approximates a data matrix using a low-rank multiplicative model based on
a fixed outer product of centered row and column effects.
}
\details{
The model assumes:
\deqn{M[i,j] = mu + a * rowEffect[i] * colEffect[j]}
where \code{mu} is the overall mean of the input matrix, and
\code{rowEffect} and \code{colEffect} are centered integer sequences.
}
