% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_module.R
\name{add_module}
\alias{add_module}
\title{Add a new SIA module to your package}
\usage{
add_module(
  name = "new_module",
  title = NULL,
  category = NULL,
  open = TRUE,
  prefix = "sm_",
  proj = curr_proj()
)
}
\arguments{
\item{name}{\emph{character}, a name for the new SIA module.}

\item{title}{\emph{character}, new module's title. You can leave the default
\code{NULL} and set manually in the manifest later on.}

\item{category}{\emph{character}, new module's category. The category dictates the
tab within the \code{{ShinyItemAnalysis}} app to which the module should be
appended. You can leave the default \code{NULL} and set manually in the manifest
later on. Check the available categories using \code{\link[=list_categories]{list_categories()}}.}

\item{open}{Whether to open the manifest and module's source for interactive
editing. Defaults to \code{TRUE}.}

\item{prefix}{\emph{character}, a prefix to denote SIA module. It's highly
recommended to stick with the default \code{"sm_"} (standing for \strong{S}IA
\strong{M}odule).}

\item{proj}{\emph{character}, a path to the project. Defaults to \link[=curr_proj]{current project}.}
}
\value{
No return value. Called for the side effects.
}
\description{
This is the workhorse of \code{{SIAtools}} package. The function checks if the
package is properly configured for SIA modules and provides immediate fixes
as needed. \code{add_module()} automatically puts a correct entry in SIA Modules
Manifest of your package (which is created if not already present), and
prepares \code{.R} file with the code template. Both files are automatically
opened for you by default.
}
\examples{
\dontrun{
# add the module called "test" and edit the details later on in the YAML
add_module("test")

# specify the title and category at creation time
add_module("test", title = "Test module", category = "Validity")
}
}
\seealso{
Other module management functions:
\code{\link{get_modules}()},
\code{\link{preview_module}()},
\code{\link{remove_module}()}
}
\concept{module_management}
