% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHAKTI.R
\name{Slope_Intercept}
\alias{Slope_Intercept}
\title{Estimation of Slope and Intercept}
\usage{
Slope_Intercept(lnKd, Temp)
}
\arguments{
\item{lnKd}{Natural logarithm of distribution coefficient}

\item{Temp}{Temperature in Kelvin}
}
\value{
\itemize{
  \item Intercept: Intercept of the fitted line
  \item Slope: Slope of the fitted line
  \item R_square: Coefficient of determination of the fitted line
}
}
\description{
Generates slope and intercept values from temperature-dependent lnKd data using linear regression, and the corresponding coefficient of determination (\eqn{R^2}) values. These coefficients form the basis for calculating the thermodynamic parameters, providing a simple and transparent bridge between experimental equilibrium measurements and thermodynamic interpretation.
}
\examples{
lnKd <- c(5.01, 5.02)
Temp <- c (298, 303)
my.SI<- Slope_Intercept(lnKd, Temp)
}
\references{
Gouaich, I., Bestani, B., Bouberka, Z., Srenscek-Nazza, J., Michalkiewicz, B., Benzekri-Benallou, M., Boucherdoud, A., and Benderdouche, N. (2023). Characterization of a low-cost Eucalyptus camaldulensis leaves based activated carbon for pharmaceutical residues removal from aqueous solutions. Desalination and Water Treatment, 296, 19–31. https://doi.org/10.5004/dwt.2023.29602
}
