#' profresp data
#'
#' The data described in Zhang et al. (2020) were downloaded from \href{https://www.openicpsr.org/openicpsr/project/109021/version/V1/view}{https://www.openicpsr.org/openicpsr/project/109021/version/V1/view} 
#' on January 22, 2020, from file survey4.rds. 
#'
#'The data set \emph{profresp} contains selected variables from the set of 2,407
#' respondents who completed the survey and provided information on the demographic variables and the information
#'needed to calculate "professional respondent" status. The full data set survey4.rds contains
#'numerous additional questions about behavior that are not included here, as well as the data
#'from the partially completed surveys. The website also contains data for three other online
#'panel surveys. Because profresp is a subset of the full data, statistics calculated from
#'it may differ from those in Zhang et al. (2020).
#'
#'Missing values are denoted by NA.
#'
#'
#'
#' @format This data frame contains the following columns:
#' 
#' \describe{
#'\item{prof_cat:}{Level of professionalism 
#'
#'1 = novice
#'
#'2 = average
#'
#'3 = professional}
#'
#'\item{panelnum:}{Number of panels respondent has belonged to. A response
#'between 1 and 6 means that the person has belonged to that
#'number of panels; 7 means 7 or more.}
#'
#'\item{survnum_cat:}{How many Internet surveys have you completed before this
#'one? 
#'
#'1 = This is my first one
#'
#'2 = 1-5
#'
#'3 = 6-10
#'
#'4 = 11-15
#'
#'5 = 16-20
#'
#'6 = 21-30
#'
#'7 = More than 30}
#'
#'\item{panelq1:}{Are you a member of any online survey panels besides this one?
#'
#'1 = yes
#'
#'2 = no}
#'
#'\item{panelq2:}{To how many other online panels do you belong?
#'
#'1 = None
#'
#' 2 = 1 other panel
#' 
#'3 = 2 others
#'
#'4 = 3 others
#'
#'5 = 4 others
#'
#'6 = 5 others
#'
#'7 = 6 others or more.
#'
#'  This question has
#'a missing value if panelq1 = 2. If you want to estimate how
#'many panels a respondent belongs to, create a new variable
#'numpanel that equals panelq2 if panelq2 is not missing and
#'equals 1 if panelq1 = 2.}
#'
#'\item{age4cat:}{Age category
#'
#'1 = 18 to 34
#'
#'2 = 35 to 49
#'
#'3 = 50 to 64
#'
#'  4 = 65 and over}
#'
#'\item{edu3cat:}{Education category
#'
#'1 = high school or less
#'
#'2 = some college or associates' degree
#'
#'  3 = college graduate or higher}
#'
#'\item{gender:}{
#'
#'1 = male
#'
#'  2 = female}
#'
#'\item{non_white:}{1 = race is non-white
#'
#'  0 = race is white}
#'
#'\item{motive:}{Which best describes your main reason for joining on-line 
#'survey panels? 
#'
#'1 = I want my voice to be heard
#'
#'2 = Completing surveys is fun
#'
#'3 = To earn money
#'
#'4 = Other (Please specify)}
#'
#'\item{freq_q1:}{During the PAST 12 MONTHS, how many times have you
#'seen a doctor or other health care professional about your
#'own health? Response is number between 0 and 999.}
#'  
#'  \item{freq_q2:}{During the PAST MONTH, how many days have you felt 
#'  you did not get enough rest or sleep?}
#'  
#'  \item{freq_q3:}{During the PAST MONTH, how many times have you eaten 
#'  in restaurants? Please include both full-service and fast food restaurants.}
#'  
#'  \item{freq_q4:}{During the PAST MONTH, how many times have you 
#'  shopped in a grocery store? If you shopped at more than one 
#'  grocery store on a single trip, please count them separately.}
#'  
#'  \item{freq_q5:}{During the PAST 2 YEARS, how many overnight trips have you taken?}
#'  
#'  
#'  }
#'  
#'  
#'  
#'  
#'  
#'
#' @docType data
#'
#' @usage data(profresp)
#'
#'
#'
#' @keywords datasets
#' 
#'@references Zhang et al. (2020). Professional respondents in
#' opt-in online panels: What do we really know? \emph{Social Science Computer Review 38 (6)},
#' 703–719.
#'
#' @references Lohr (2021), Sampling: Design and Analysis, 3rd Edition. Boca Raton, FL: CRC Press.
#' 
#'@references Lu and Lohr (2021), R Companion for \emph{Sampling: Design and Analysis, 3rd Edition}, 1st Edition. Boca Raton, FL: CRC Press.
#' 
#'
#' 
#' 
#' 
"profresp"

