% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_pupil.R
\docType{data}
\name{pupil}
\alias{pupil}
\title{Trajectories of Pupil Response to Light after Cannabis Use}
\format{
A tibble with 15000 rows and 10 variables:
\describe{
\item{id}{Factor. Subject identifier (127 unique levels).}
\item{use_group}{Character. Original usage group classification (e.g., "Daily - Flower", "No Use").}
\item{use}{Numeric. Binary indicator of cannabis use 40 minute prior to the light stimulus. (1 = user, 0 = non-user)}
\item{age}{Integer. Subject's age.}
\item{gender}{Numeric. Binary indicator of subject's gender: 1 = Female, 0 = Male.}
\item{bmi}{Numeric. Body Mass Index.}
\item{alcohol}{Numeric. Alcohol use score.}
\item{seconds}{Numeric. Time in seconds since light stimulus.}
\item{percent_change_baseline}{Numeric. Percent change relative to baseline.}
\item{percent_change}{Numeric. Percent change in the outcome of interest.}
}
}
\source{
Processed from \code{data-raw/pupil_load.R} using the \code{readr} and \code{dplyr} packages.
}
\usage{
data(pupil)
}
\description{
Dataset contains functional observation of pupil size percent change after a light stimulus.
Participants in the cannabis use group smoked cannabis flower or concentrate 40 minutes prior to the pupillometry measurement.
Goal of this data is to understand differences in pupil response to light driven by acute cannabis users.
Measurements were collected on the right eye.
}
\references{
Godbole, S., Leroux, A., Brooks-Russell, A., Subramanian, P. S., Kosnett, M. J., & Wrobel, J. (2024).
A Study of Pupil Response to Light as a Digital Biomarker of Recent Cannabis Use.
\emph{Digital biomarkers}, 8(1), 83–92.
\doi{10.1159/000538561}
}
\keyword{dataset}
