% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_loglik.R
\name{calc.loglik.a}
\alias{calc.loglik.a}
\alias{calc.loglik.b}
\alias{calc.loglik.k}
\title{Calculates marginal likelihood}
\usage{
calc.loglik.a(a, y, mu, sf)

calc.loglik.b(b, y, mu, sf)

calc.loglik.k(k, y, mu, sf)
}
\arguments{
\item{a, b, k}{Prior parameter.}

\item{y}{A vector of observed gene counts.}

\item{mu}{A vector of predictions from \code{\link{expr.predict}}.}

\item{sf}{Vector of normalized size factors.}
}
\value{
A shifted negative marginal log-likelihood.
}
\description{
Calculates the marginal likelihood given the prediction under constant
coefficient of variation (a), Fano factor (b), and variance (k).
}
\details{
\code{calc.loglik.a} returns the shifted negative log-likelihood under
constant coefficient of variation.
\code{calc.loglik.b} returns the shifted negative log-likelihood under
constant Fano factor.
\code{calc.loglik.k} returns the shifted negative log-likelihood under
constant variance.
}
