% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc.plot.R
\name{rc.plot}
\alias{rc.plot}
\title{Reconstructed Image Plot}
\usage{
rc.plot(x, type = c("binary", "segments"), publication = FALSE, ...)
}
\arguments{
\item{x}{an integer matrix that represents the reconstructed image.}

\item{type}{a character string that specifies the image type.}

\item{publication}{a logical value, whether to create a figure without key nor scales.}

\item{...}{additional graphical parameters passed to \code{\link[lattice]{levelplot}}.}
}
\value{
No return value, called for side effects i.e. plotting.
}
\description{
Plot a reconstructed image obtained from various types of modalities.
}
\details{
The argument \code{type} specifies the image type with the following options:
\itemize{
\item binary: reconstructed binary image, representing a greyscale medical image;
\item segments: segmented matrix, where each region is denoted by an integer value.
}
}
\seealso{
\code{\link{binary.segmentation}} for more information on reconstructed images.
}
