% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_plug_and_play.R
\name{fit_plug_and_play}
\alias{fit_plug_and_play}
\title{Fit presence-background distribution models in a plug-and-play framework.}
\usage{
fit_plug_and_play(
  presence = NULL,
  background = NULL,
  method = NULL,
  presence_method = NULL,
  background_method = NULL,
  bootstrap = "none",
  bootstrap_reps = 100,
  ...
)
}
\arguments{
\item{presence}{dataframe of covariates at presence points}

\item{background}{Optional. Dataframe of covariates at background points}

\item{method}{Optional. If supplied, both presence and background density estimation will use this method.}

\item{presence_method}{Optional. Method for estimation of presence density.}

\item{background_method}{Optional. Method for estimation of background density.}

\item{bootstrap}{Character.  One of "none" (the default, no bootstrapping),
"numbag" (presence function is bootstrapped),
or "doublebag" (presence and background functions are bootstrapped).}

\item{bootstrap_reps}{Integer.  Number of bootstrap replicates to use (default is 100)}

\item{...}{Additional parameters passed to internal functions.}
}
\value{
List of class "pnp_model" containing model objects and metadata needed for projecting the fitted models.
}
\description{
This function fits presence-background species distribution models for the specified plug-and-play methods \insertCite{Drake2018-ha,Drake2015-sb}{S4DM}.
}
\details{
Current methods include: "gaussian", "kde","vine","rangebagging", "lobagoc", and "none".
}
\note{
Either \code{method} or both \code{presence_method} and \code{background_method} must be supplied.
}
\examples{
\donttest{

# load in sample data

 library(S4DM)
 library(terra)

 # occurrence points
   data("sample_points")
   occurrences <- sample_points

 # environmental data
   env <- rast(system.file('ex/sample_env.tif', package="S4DM"))

 # rescale the environmental data

   env <- scale(env)

 # Get presence environmental data

  pres_env <- get_env_pres(coords = occurrences,
                           env = env)

# Get background environmental data

 bg_env <- get_env_bg(coords = occurrences,
                      env = env,width = 100000)


# Note that the functions to get the environmental data return lists,
# and only the "env" element of these is used in the fit function

  kde_fit <- fit_plug_and_play (presence = pres_env$env,
                                background = bg_env$env,
                                method = "kde")

}
}
\references{
\insertAllCited{}
}
