% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_functions.R
\name{tsEvaNanRunnigBlowTh}
\alias{tsEvaNanRunnigBlowTh}
\title{Calculate the return period of low flow based on a threshold and window size}
\usage{
tsEvaNanRunnigBlowTh(series, threshold, windowSize)
}
\arguments{
\item{series}{The time series data.}

\item{threshold}{The threshold value for low flow.}

\item{windowSize}{The size of the sliding window.}
}
\value{
A data frame with two columns: "time" representing the time points
corresponding to the sliding windows, and "RP" representing the
calculated return period of low flow.
}
\description{
This function calculates the return period of low flow for a given time series
based on a threshold and window size. It uses a sliding window approach to
count the number of values below the threshold within each window, and then
calculates the return period based on the proportion of values below the
threshold. Assumes that the input data has a 7 days timestep.
}
\examples{
series <- c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
threshold <- 5
windowSize <- 3
tsEvaNanRunnigBlowTh(series, threshold, windowSize)

}
