% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_raster_plot.R
\name{create_raster_plot}
\alias{create_raster_plot}
\title{create_raster_plot}
\usage{
create_raster_plot(
  df,
  aes_x = NULL,
  aes_y = NULL,
  aes_color = NULL,
  aes_fill = NULL,
  interpolate = FALSE,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  center_titles = FALSE,
  x_title = NULL,
  y_title = NULL,
  hide_x_tics = FALSE,
  hide_y_tics = FALSE,
  panel_color = "white",
  panel_border_color = "black",
  x_limits = NULL,
  x_major_breaks = waiver(),
  x_minor_breaks = waiver(),
  x_labels = waiver(),
  y_limits = NULL,
  y_major_breaks = waiver(),
  y_minor_breaks = waiver(),
  y_labels = waiver(),
  scale_breaks = waiver(),
  scale_values = NULL,
  scale_limits = NULL,
  scale_labels = waiver(),
  scale_colors = heat.colors(8),
  scale_na_value = "gray50",
  own_scale = FALSE,
  show_legend = TRUE,
  legend_pos = "right",
  legend_key_width = 0.5,
  legend_key_height = 0.7,
  legend_key_backgrd = "white"
)
}
\arguments{
\item{df}{The required data.frame derived from a raster file (such as *.tiff) to be plotted.}

\item{aes_x}{The required name of aesthetic variable from 'df' for the x dimension.}

\item{aes_y}{The required name of aesthetic variable from 'df' for the y dimension.}

\item{aes_color}{The variable name from 'df' for the attribute dependent aesthetic mapping for color.}

\item{aes_fill}{The variable name from 'df' for the attribute dependent aesthetic mapping for fill.}

\item{interpolate}{A logical which if TRUE interpolate linearly.}

\item{title}{A string that sets the plot title.}

\item{subtitle}{A string that sets the plot subtitle.}

\item{caption}{A string that sets the plot caption}

\item{center_titles}{A logical which if \code{TRUE} centers both the 'title' and 'subtitle'.}

\item{x_title}{A string that sets the x axis title. If NULL (the default) then the x axis title does not appear.}

\item{y_title}{A string that sets the y axis title. If NULL (the default)  then the y axis title does not appear.}

\item{hide_x_tics}{A logical that controls the appearance of the x axis tics.}

\item{hide_y_tics}{A logical that controls the appearance of the y axis tics.}

\item{panel_color}{A string in hexidecimal or color name that sets the plot panel's color.
The default is "white".}

\item{panel_border_color}{A string in hexidecimal or color name that sets the plot panel's border color.
The default is "black".}

\item{x_limits}{Depending on the class of 'aes_x', a numeric/Date/POSIXct 2 element vector that sets the minimum
and maximum for the x axis. Use \code{NA} to refer to the existing minimum and maximum.}

\item{x_major_breaks}{Depending on the class of 'aes_x', a numeric/Date/POSIXct vector or function that defines
the exact major tic locations along the x axis.}

\item{x_minor_breaks}{Depending on the class of 'aes_x', a numeric/Date/POSIXct vector or function that defines
the exact minor tic locations along the x axis.}

\item{x_labels}{A character vector with the same length as 'x_major_breaks', that labels the major tics.}

\item{y_limits}{A numeric 2 element vector that sets the minimum and  maximum for the y axis.
Use \code{NA} to refer to the existing minimum and maximum.}

\item{y_major_breaks}{A numeric vector or function that defines the exact major tic locations along the y axis.}

\item{y_minor_breaks}{A numeric vector or function that defines the exact minor tic locations along the y axis.}

\item{y_labels}{A character vector with the same length as 'y_major_breaks', that labels the major tics.}

\item{scale_breaks}{A string/numeric vector that defines the scale breaks.}

\item{scale_values}{A string/numeric vector that defines the possible values.}

\item{scale_limits}{A string/numeric vector that defines the scale limits.}

\item{scale_labels}{An optional string vector that defines the scale labels. Vector must be the same length
as \code{scale_breaks}.}

\item{scale_colors}{Vector of colors to use for n-color gradient.}

\item{scale_na_value}{A string that sets the color for missing values.}

\item{own_scale}{A logical which if \code{TRUE}, then your own scaling may be appended to the plot without using the above
scale_* parameters.}

\item{show_legend}{A logical that controls the appearance of the legend.}

\item{legend_pos}{A string that sets the legend position. Acceptable values are
"top", "bottom", "left", "right".}

\item{legend_key_width}{A numeric that sets the legend width in cm.}

\item{legend_key_height}{A numeric that sets the legend height in cm.}

\item{legend_key_backgrd}{A string that sets the legend's background color.}
}
\value{
A ggplot class object.
}
\description{
The function is wrapper around \code{ggplot2::geom_raster()} that plots from a data.frame with
 columns for x and y coordinates along with an associated numeric attribute.

The function accepts a data frame with columns for numeric x/y values and an attribute
 that will be mapped as a color or fill aesthetic. Function provides additional
 ggplot2 text labeling and axis scaling.
}
\examples{
library(ggplot2)
library(RplotterPkg)

RplotterPkg::create_raster_plot(
  df = RplotterPkg::kentucky_elevation,
  title = "County Elevations in Southeast Kentucky",
  aes_x = "x",
  aes_y = "y",
  aes_fill = "elevation"
) +
ggplot2::geom_sf(
  data = RplotterPkg::kentucky_counties,
  aes(x = NULL, y = NULL),
  alpha = 0,
  linewidth = 1.5
) +
ggplot2::geom_sf_text(
  data = RplotterPkg::kentucky_counties,
  aes(x = NULL, y = NULL, label = ID)
)

}
