% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Whereisit.R
\name{Orbit.location}
\alias{Orbit.location}
\title{Calculate location of a planet
\code{Orbit.location}}
\usage{
Orbit.location(t, p.orb, a = 1, theta = 0, orig = c(0, 0), ab = 1)
}
\arguments{
\item{t}{Time (day).}

\item{p.orb}{Period of the orbit.}

\item{a}{Radius or Semi-major of the orbit.}

\item{theta}{angle in PCS.}

\item{orig}{Reference orgin.}

\item{ab}{Semi-major over semi-minor. ab=1 for a Ring.}
}
\value{
(x,y) in Cartesian Coordinate System.
}
\description{
Calculate location of a planet
\code{Orbit.location}
}
\examples{
tday = seq(0, 365, 30)
x=Orbit.location(t=tday, p.orb = 365, a=10)
plot(PCS2CCS(0:360, a=10), type='l')
plotplanet(orig=x, rad = .51)
grid()
}
