% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{survival_comparison_functions}
\alias{survival_comparison_functions}
\alias{robin_surv_no_strata_no_cov}
\alias{robin_surv_strata}
\alias{robin_surv_cov}
\alias{robin_surv_strata_cov}
\title{Survival Comparison Functions}
\usage{
robin_surv_no_strata_no_cov(vars, data, exp_level, control_level)

robin_surv_strata(vars, data, exp_level, control_level)

robin_surv_cov(vars, data, exp_level, control_level, ...)

robin_surv_strata_cov(vars, data, exp_level, control_level, ...)
}
\arguments{
\item{vars}{(\code{list}) A list containing \code{levels}, \code{treatment}, and \code{covariates}.}

\item{data}{(\code{data.frame}) The data frame containing the survival data.}

\item{exp_level}{(\code{count}) Level of the experimental treatment arm.}

\item{control_level}{(\code{count}) Level of the control treatment arm.}

\item{...}{Additional arguments passed to \code{score_fun}.}
}
\value{
See \code{\link[=robin_surv_comparison]{robin_surv_comparison()}}.
}
\description{
These are simple wrappers around \code{\link[=robin_surv_comparison]{robin_surv_comparison()}} called with the corresponding log-rank score
functions.
}
\section{Functions}{
\itemize{
\item \code{robin_surv_no_strata_no_cov()}: without strata and without covariates, based on
\code{\link[=h_lr_score_no_strata_no_cov]{h_lr_score_no_strata_no_cov()}}.

\item \code{robin_surv_strata()}: without strata and without covariates, based on
\code{\link[=h_lr_score_strat]{h_lr_score_strat()}}.

\item \code{robin_surv_cov()}: without strata and without covariates, based on
\code{\link[=h_lr_score_cov]{h_lr_score_cov()}} and \code{\link[=h_lr_score_no_strata_no_cov]{h_lr_score_no_strata_no_cov()}} (which is used to find the unadjusted
log hazard ratio estimate).

\item \code{robin_surv_strata_cov()}: with strata and covariates, based on
\code{\link[=h_lr_score_strat_cov]{h_lr_score_strat_cov()}} and \code{\link[=h_lr_score_strat]{h_lr_score_strat()}} (which is used to find the unadjusted
log hazard ratio estimate).

}}
\keyword{internal}
