% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{weibull-aft}
\alias{weibull-aft}
\alias{weibull_aft_log_density}
\alias{weibull_aft_log_hazard}
\alias{weibull_aft_log_survival}
\alias{weibull_aft_density}
\alias{weibull_aft_hazard}
\alias{weibull_aft_survival}
\alias{weibull_aft_mean}
\alias{weibull_aft_sd}
\alias{weibull_aft_r}
\alias{weibull_aft_q}
\alias{weibull_aft_p}
\title{Weibull AFT parametric family.}
\usage{
weibull_aft_log_density(t, eta, shape)

weibull_aft_log_hazard(t, eta, shape)

weibull_aft_log_survival(t, eta, shape)

weibull_aft_density(t, eta, shape)

weibull_aft_hazard(t, eta, shape)

weibull_aft_survival(t, eta, shape)

weibull_aft_mean(eta, shape)

weibull_aft_sd(eta, shape)

weibull_aft_r(n, eta, shape)

weibull_aft_q(p, eta, shape)

weibull_aft_p(q, eta, shape)
}
\arguments{
\item{t}{vector of survival times}

\item{eta}{linear predictor}

\item{shape}{auxiliary parameter}

\item{n}{number of observations}

\item{p}{vector of probabilities}

\item{q}{vector of quantiles}
}
\value{
\code{weibull_aft_density}, \code{weibull_aft_hazard}, and
\code{weibull_aft_survival} return the density, hazard, and survival
of the specified survival distribution. The \code{weibull_aft_log_density},
\code{weibull_aft_log_hazard}, \code{weibull_aft_log_survival} return log of
the corresponding qualities. \code{weibull_aft_mean} and \code{weibull_aft_sd}
return the mean and standard deviation of the specified survival distribution.
\code{weibull_aft_r}, \code{weibull_aft_q}, and \code{weibull_aft_p} return a random
generation, quantiles, and cumulative probabilities of the specified
survival distribution.
}
\description{
(log) density, hazard, and survival
functions for AFT Weibull parametric family.
}
