% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{lnorm-aft}
\alias{lnorm-aft}
\alias{lnorm_aft_log_density}
\alias{lnorm_aft_log_hazard}
\alias{lnorm_aft_log_survival}
\alias{lnorm_aft_density}
\alias{lnorm_aft_hazard}
\alias{lnorm_aft_survival}
\alias{lnorm_aft_mean}
\alias{lnorm_aft_sd}
\alias{lnorm_aft_r}
\alias{lnorm_aft_q}
\alias{lnorm_aft_p}
\title{Log-normal AFT parametric family.}
\usage{
lnorm_aft_log_density(t, eta, sd)

lnorm_aft_log_hazard(t, eta, sd)

lnorm_aft_log_survival(t, eta, sd)

lnorm_aft_density(t, eta, sd)

lnorm_aft_hazard(t, eta, sd)

lnorm_aft_survival(t, eta, sd)

lnorm_aft_mean(eta, sd)

lnorm_aft_sd(eta, sd)

lnorm_aft_r(n, eta, sd)

lnorm_aft_q(p, eta, sd)

lnorm_aft_p(q, eta, sd)
}
\arguments{
\item{t}{vector of survival times}

\item{eta}{linear predictor}

\item{sd}{auxiliary parameter}

\item{n}{number of observations}

\item{p}{vector of probabilities}

\item{q}{vector of quantiles}
}
\value{
\code{lnorm_aft_density}, \code{lnorm_aft_hazard}, and
\code{lnorm_aft_survival} return the density, hazard, and survival
of the specified survival distribution. The \code{lnorm_aft_log_density},
\code{lnorm_aft_log_hazard}, \code{lnorm_aft_log_survival} return log of
the corresponding qualities. \code{lnorm_aft_mean} and \code{lnorm_aft_sd}
return the mean and standard deviation of the specified survival distribution.
\code{lnorm_aft_r}, \code{lnorm_aft_q}, and \code{lnorm_aft_p} return a random
generation, quantiles, and cumulative probabilities of the specified
survival distribution.
}
\description{
(log) density, hazard, and survival
functions for AFT log-normal parametric family.
}
