% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{contr.BayesTools}
\alias{contr.BayesTools}
\alias{contr.orthonormal}
\alias{contr.meandif}
\alias{contr.independent}
\title{BayesTools Contrast Matrices}
\usage{
contr.orthonormal(n, contrasts = TRUE)

contr.meandif(n, contrasts = TRUE)

contr.independent(n, contrasts = TRUE)
}
\arguments{
\item{n}{a vector of levels for a factor, or the number of levels}

\item{contrasts}{logical indicating whether contrasts should be computed}
}
\description{
BayesTools provides several contrast matrix functions for Bayesian factor analysis.
These functions create different types of contrast matrices that can be used with factor
variables in Bayesian models.
}
\details{
The package includes the following contrast functions:
\describe{
\item{\code{contr.orthonormal}}{Return a matrix of orthonormal contrasts.
Code is based on \code{stanova::contr.bayes} and corresponding to description
by \insertCite{rouder2012default;textual}{BayesTools}. Returns a matrix with n rows and
k columns, with k = n - 1 if \code{contrasts = TRUE} and k = n if \code{contrasts = FALSE}.}
\item{\code{contr.meandif}}{Return a matrix of mean difference contrasts.
This is an adjustment to the \code{contr.orthonormal} that ascertains that the prior
distributions on difference between the gran mean and factor level are identical independent
of the number of factor levels (which does not hold for the orthonormal contrast). Furthermore,
the contrast is re-scaled so the specified prior distribution exactly corresponds to the prior
distribution on difference between each factor level and the grand mean -- this is approximately
twice the scale of \code{contr.orthonormal}. Returns a matrix with n rows and k columns,
with k = n - 1 if \code{contrasts = TRUE} and k = n if \code{contrasts = FALSE}.}
\item{\code{contr.independent}}{Return a matrix of independent contrasts -- a level for each term.
Returns a matrix with n rows and k columns, with k = n if \code{contrasts = TRUE} and k = n
if \code{contrasts = FALSE}.}
}
}
\examples{
# Orthonormal contrasts
contr.orthonormal(c(1, 2))
contr.orthonormal(c(1, 2, 3))

# Mean difference contrasts
contr.meandif(c(1, 2))
contr.meandif(c(1, 2, 3))

# Independent contrasts
contr.independent(c(1, 2))
contr.independent(c(1, 2, 3))

}
\references{
\insertAllCited{}
}
