% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-harmo_process_harmonization.R
\name{as_data_proc_elem}
\alias{as_data_proc_elem}
\title{Validate and coerce as a Data Processing Elements object}
\usage{
as_data_proc_elem(object)
}
\arguments{
\item{object}{A potential Data Processing Elements object to be coerced.}
}
\value{
A data frame with \code{Rmonize::class} 'data_proc_elem'.
}
\description{
Checks if an object is a valid Data Processing Elements and returns it with
the appropriate \code{Rmonize::class} attribute. This function mainly helps
validate inputs within other functions of the package but could be used
separately to ensure that an object has an appropriate structure.
}
\details{
The Data Processing Elements specifies the input elements and processing algorithms
to generate harmonized variables in the DataSchema formats. It is also
contains metadata used to generate documentation of the processing.
A Data Processing Elements object is a data frame with specific columns
used in data processing: \code{dataschema_variable}, \code{input_dataset},
\code{input_variables}, \code{Mlstr_harmo::rule_category} and \code{Mlstr_harmo::algorithm}.
To initiate processing, the first entry must be the creation of a harmonized
primary identifier variable (e.g., participant unique ID).
}
\examples{
{

# Use Rmonize_examples to run examples.
library(dplyr)

data_proc_elem <- as_data_proc_elem(Rmonize_examples$`Data_Processing_Elements_no_errors`)

head(data_proc_elem)

}

}
