% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Analyses_functions_1.R
\name{X_max}
\alias{X_max}
\title{Estimated maximum of a time series}
\usage{
X_max(X, subI = NULL, plot = FALSE, vline = FALSE, hline = FALSE)
}
\arguments{
\item{X}{Data frame where the first column is a numeric time sequence \eqn{(t)}
and the second the values of the time series \eqn{(X(t))}.}

\item{subI}{Time sub-interval is a vector where the lower bound is
the first element and upper bound is the second. Optional: If provided maximum of the
sub-interval is returned, otherwise the whole time sequence is considered.}

\item{plot}{Logical: If \code{TRUE}, the time series, the maximum and corresponding \eqn{t} values are plotted in interactive sessions.}

\item{vline}{Logical: If \code{TRUE}, a vertical line is plotted across the maximum.}

\item{hline}{Logical: If \code{TRUE}, a horizontal line is plotted across the maximum.}
}
\value{
A list of numeric vector(s). The first element in the vector is the corresponding \eqn{t} value and second the
maximum of the time series.
}
\description{
This function computes the maximum of a time series for the provided
time interval or its sub-interval.
}
\examples{
t <- seq(0, 1, length = 100)
TS <- data.frame("t" = t, "X(t)" = rnorm(100))
X_max(TS, subI = c(0.5, 0.8), plot = TRUE)

}
\seealso{
\code{\link{X_min}}
}
