% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{RmecabKo}
\alias{RmecabKo}
\alias{RmecabKo-package}
\title{Rcpp Wrapper for Eunjeon Project}
\description{
The \code{mecab-ko} and \code{mecab-ko-dic} is based on a \code{C++} library,
and POS tagging with them is useful when the spacing of source text is not correct.
For integrating \code{mecab-ko} with \code{R}, \code{Rcpp} package is used for providing the basic framework.
}
\details{
It is based on the \code{Eunjeon Project}.
For Mac OSX and Linux, You need to install \code{mecab-ko} and \code{mecab-ko-dic} before install this package in R.
\code{mecab-ko}: \url{https://bitbucket.org/eunjeon/mecab-ko}
\code{mecab-ko-dic}: \url{https://bitbucket.org/eunjeon/mecab-ko-dic}
In Windows, \code{install_mecab(mecabLocation)} function will install \code{mecab-ko-msvc} and \code{mecab-ko-dic-msvc} in user specified directory.
It is operated by system command and file I/O, the speed of the analysis is slow compared to the Linux-based operating system.
}
\examples{
\dontrun{
# install.packages("devtools")
devtools::install_github("junhewk/RmecabKo")
# On Windows platform only
install_mecab("D:/Rlibs/mecab")

phrase <- # Some Korean character vectors

# For full POS tagging
pos(phrase)
# For noun extraction only
nouns(phrase)
# For tokenizing of selective morphemes
tokens_words(phrase)
# For n-grams tokenizing
tokens_ngram(phrase)
}

}
\references{
\itemize{
\item{\href{http://eunjeon.blogspot.com}{Eunjeon project}}
\item{\href{https://github.com/Pusnow}{Wonsup Yoon}, mecab-ko VC++ builds at \url{https://github.com/Pusnow/mecab-ko-msvc}, \url{https://github.com/Pusnow/mecab-ko-dic-msvc}}
}
}
\author{
Junhewk Kim
}
\keyword{Korean}
\keyword{nlp}
\keyword{tagger}
