% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IEX_Market_Data.R
\name{iex.earnings}
\alias{iex.earnings}
\title{Earnings data for a given company including the actual EPS, consensus, and fiscal period.
Earnings are available quarterly (last 4 quarters)}
\usage{
iex.earnings(x, iex_sk)
}
\arguments{
\item{x}{A character vector that can include one or multiple  Tickers / Stocks Symbols}

\item{iex_sk}{is a character vector that include IEX Cloud API Secret Token}
}
\value{
Data frame that include earnings
}
\description{
For more details, visit:\url{https://iexcloud.io/docs/api/#earnings}
}
\examples{
\dontrun{
  iex.earnings("TSLA", "sk")
}
}
\seealso{
Investors Exchange `IEX` developer guide \url{https://iexcloud.io/docs/api/}

Investors Exchange Group (IEX Group) offers flexible and salable pricing.\url{https://iexcloud.io/pricing/}

View Investors Exchange Group (IEX Group) terms of use and subscription levels.\url{https://iexcloud.io/terms/}

Package `iexcloudR`\url{https://github.com/schardtbc/iexcloudR}
}
\author{
Myriam Ibrahim
}
