% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmOutliers.R
\name{rmOutliers}
\alias{rmOutliers}
\title{A function to remove outliers from the "score" column of a supplied bed dataframe
There are three methods: max, IQR and median. Max is used to remove 1 or more maximum
values; IQR uses interquartile range to detect outliers, while median method can be
used to remove data based on genome-wide median.}
\usage{
rmOutliers(bed, method, n = 1, range = 3, loLim = 0.25, hiLim = NULL)
}
\arguments{
\item{bed}{A dataframe containing 'score' column (dataframe, required).}

\item{method}{Method to detect outliers: "max", "IQR" or "median" (string).}

\item{n}{Number of max values to remove (integer,defaults to 1). Use with "max" method.}

\item{range}{Number of IQR above the 3rd or below the 1st IQR to set the threshold (double, defaults to 3).
Use with "IQR" method.}

\item{loLim}{Low limit for the median method (double, defaults to 0.25).}

\item{hiLim}{High limit for the median method (double).}
}
\description{
A function to remove outliers from the "score" column of a supplied bed dataframe
There are three methods: max, IQR and median. Max is used to remove 1 or more maximum
values; IQR uses interquartile range to detect outliers, while median method can be
used to remove data based on genome-wide median.
}
\examples{
bedDF <- rmOutliers(W303_S,method="max",n=2) ## removes 2 rows of data containing 3 top values
bedDF <- rmOutliers(W303_S,method="IQR",range=3) ## removes datapoints outside 3 x IQR above the 3rd
 # and below the 1st IQR.
bedDF <- rmOutliers(W303_S,method="median",loLim=0.25,hiLim=2) # removes datapoints that are lower
 # than 0.25 x genome median or above 2 x genome median.
}
\keyword{BED}
\keyword{bioinformatics}
\keyword{genomics}
\keyword{outliers}
