% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volatilidad.R
\name{volatilidad}
\alias{volatilidad}
\title{Dimensionality of voting. Volatility}
\usage{
volatilidad(dat1, dat2, enlace)
}
\arguments{
\item{dat1}{It is a data.frame with two columns. The first column contains the acronym
of the political party and the second the votes or seats obtained from the first period
of time, depending on whether you want to calculate the electoral or parliamentary
volatility respectively.}

\item{dat2}{It is a data.frame with two columns. The first column contains the acronym
of the political party and the second the votes or seats obtained from the second period
of time, depending on whether you want to calculate the electoral or parliamentary
volatility respectively.}

\item{enlace}{It is a data.frame that serves to link the parties, coalitions or groupings
that you want to compare between the two periods under study. This data.frame contains a
total of 22 columns. The first column contains the corresponding name of the political
parties. The next 10 columns (called p1_i for i=1,2,...,10) are used to indicate the
number of the row(s) of the party(ies) of the first electoral period to be grouped. The
next 10 columns (called p2_i for i=1,2,...,10) are used to indicate the number of the
row(s) of the party(ies) of the second electoral period to be grouped. When some of the
10 columns are not needed, the remaining columns are filled in with zeros. The data in each
row is used with following purpose: For the first block of 10 columns, the votes/seats of the
parties appearing in that block are added up. For the second block of 10 columns, the
votes/seats in that second block are also added up. These two values will be used later on
for comparison. The last column of this data.frame (called "block"), will contain the values
"D" or "I" indicating "Right", "Left", respectively.

To clarify all these concepts execute in R \emph{browseVignettes("Relectoral")} or \emph{vignette("Volatility")}}
}
\value{
It returns a list with two objects. The first is the total volatility, and the second
is the inter-block volatility.
}
\description{
This function calculates the total volatility of Pederson (1983:31 and 32),
and the volatility between blocks. The formulas for calculating these values can be
found in Oñate and Ocaña's book "Analysis of electoral data", page 45. This dimension
compares the behaviour of the electorate in two different elections, so as to see the
transfer of votes, either between blocks or between political parties.
}
