% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Electoral_index.R
\name{fragmentacion_rae}
\alias{fragmentacion_rae}
\title{Rae's fragmentation (electoral and parliamentary) vote dimension (F)}
\usage{
fragmentacion_rae(votes, seats)
}
\arguments{
\item{votes}{It is a vector of integers, containing the votes of all the candidates.}

\item{seats}{It is a vector of integers, containing the seats obtained by each of the candidates.}
}
\value{
Returns a dataframe, with the columns "electoral" and "parliamentary" to store respectively
the value of the electoral or parliamentary fragmentation index.
}
\description{
This indicator seeks to summarize in one value the level of dispersion or
concentration of political power, that is to say, whether or not
the seats or votes received are concentrated in a reduced number of political parties. The values
of the index vary between 0 and 1, so that a value of zero indicates no fragmentation
(all the votes go to a single party), while a value close to one indicates strong
electoral fragmentation

Este indicador pretende resumir en un valor el nivel de dispersión o concentración del
poder político, es decir y de forma resumida si se encuentra concentrado o no los escaños o votos
recibidos en una serie de partidos polítcos. Los valores del índice varían entre 0 y 1, de forma que
un valor cero indica no hay ninguna fragmentación ( todos los votos van a un sólo partido), mientras
que un valor dercano a uno indica fuerte fragmentación electoral

The formula used for its calculation is as follows:

\deqn{1-\sum_{i}q_{i}^{2}}{1-sum(qi^2)]}
for \eqn{i =  1, 2, \ldots,n }

Where q_i are the proportions (as parts per unit) of the number of seats or votes (electoral
or parliamentary indicator), of the votes obtained by each candidate.
}
\examples{

fragmentacion_rae(c(3947,3189,1971,466,345,82),c(184,99,44,10,1,0))

}
