% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step4.R
\name{Step4}
\alias{Step4}
\title{Step 4 of the Hartigan and Wong algorithm}
\usage{
Step4(
  data,
  centers,
  grouping,
  LIVE_SET_original,
  distance,
  centers_function,
  Ic12_change,
  index
)
}
\arguments{
\item{data}{Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.}

\item{centers}{Matrix with \code{dim(centers)[1]} centers of \code{dim(centers)[2]} dimensions.}

\item{grouping}{List. Each component of the list contains a vector with the points that belong to that group. More specifically, the list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.}

\item{LIVE_SET_original}{Vector that contains the groups that have been modified in the previous Step 6. The Step 6 is described in Hartigan and Wong (1979).}

\item{distance}{Function. This function designs how the distance is going to be calculated. It must have as input two vectors and as output the distance of these vectors.}

\item{centers_function}{Function. This function designs how the centers of the groups will be calculated. It must have as input \code{data} and \code{grouping} and as output a matrix that has the centers. This matrix will have as many rows as centers.}

\item{Ic12_change}{Matrix. The first row contains the IC1 of each point. The second column contains the IC2 of each point. IC1 and IC2 are the closets and second closest cluster centers.}

\item{index}{Number. When a point is reallocated, index becomes zero.}
}
\value{
Returns a list with:

\itemize{
  \item centers: the information of the centers updated. Matrix with \code{dim(centers)[1]} centers of \code{dim(centers)[2]} dimensions.
  \item  IC1andIC2: the information of the IC1 and IC2 updated. Matrix.  The first row contains the IC1 of each point. The second column contains the IC2 of each point. IC1 and IC2 are the closets and second closest cluster centers.
  \item  grouping: the information of the groups updated. List. Each component of the list contains a vector with the points that belong to that group. More specifically, the list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.
  \item Live_set: Vector. Contains the groups that have been modified during the Step 4.
  \item  no_Change: vector with the points that do not change its group. More specifically, contains the row of the matrix \code{data} where these points are.
  }
}
\description{
This function implements the Step 4 of the Hartigan and Wong (Hartigan and Wong, 1979) algorithm without imposing that the use of the euclidean distance  and without imposing that the centers of the groups are calculated by averaging the points. This function allows other distances to be used and allows the centers of the groups to be calculated in different ways.
}
\examples{

set.seed(231)
data1=gtools::rdirichlet(10,c(1,1,4,4,20,20))
data=t(data1)
k=3
seed=5



if(!is.null(seed)){
 set.seed(seed)
}
centers <- data[sample(1:nrow(data), k), ]

#We calculate the distance between each row of the data matrix and the centers
Dist_e_cent=matrix(0,dim(data)[1],dim(centers)[1])
for (i in 1:(dim(data)[1])){
for (j in 1:(dim(centers)[1])){
 Dist_e_cent[i,j]=Euclideandistance(data[i,],centers[j,])
}
}


Ic12=Dist_IC1_IC2(Dist_e_cent)
Ic12_change=Ic12
Group=Ic12[,1]
grouping<-list()
for(i in 1:(max(Group))){
grouping[[i]]=which(Group==i)
}

#Update the clusters centers.
centers=centers_function_mean(data, grouping)

#Live set.
LIVE_SET_original1=c(1:length(grouping))

index=0

P1=Step4(data,
        centers,
        grouping,
        LIVE_SET_original1,
        Euclideandistance,
        centers_function_mean,
        Ic12_change,
        index)



}
\references{
Hartigan, J. A., & Wong, M. A. (1979). Algorithm AS 136: A k-means clustering algorithm. Journal of the royal statistical society. series c (applied statistics), 28(1), 100-108.
}
