% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N.record.R
\name{N.record}
\alias{N.record}
\alias{Nmean.record}
\title{Number of Records}
\usage{
N.record(X, record = c("upper", "lower"), weak = FALSE)

Nmean.record(X, record = c("upper", "lower"), weak = FALSE)
}
\arguments{
\item{X}{A numeric vector, matrix (or data frame).}

\item{record}{A character string indicating the type of record to be 
calculated, "upper" or "lower".}

\item{weak}{Logical. If \code{TRUE}, weak records are also counted. Default
to \code{FALSE}.}
}
\value{
\code{N.record} returns a numeric matrix with the number of records 
  up to each time (row) \eqn{t} for a vector or each column in \code{X}. 
  \code{Nmean.record} returns a numeric vector with the mean number of 
  records in \eqn{M} series (columns) up to each time (row) \eqn{t}.
}
\description{
Returns the number of records up to time \eqn{t} of the
  values in a vector.
  
  If the argument \code{X} is a matrix, then each column is treated as a 
  different vector.
}
\details{
The record counting process \eqn{\{N_1,\ldots,N_T\}} is defined by 
  the number of records up to time \eqn{t}, and can be expressed in terms of 
  the record indicator random variables \code{\link{I.record}} by
  \deqn{N_t = I_1 + I_2 + \ldots + I_t.}

  If \code{X} is a matrix with \eqn{M > 1} columns, each column is treated
  as a vector and \code{Nmean.record} calculates for each \eqn{t},
  \deqn{\bar N_t = \frac{N_{t1}+ \ldots + N_{tM}}{M}.}
  
  In summary:
  \deqn{\code{N.record}: \code{X} = \left(
                 \begin{array}{cccc} 
                   X_{1,1} & X_{1,2} & \cdots & X_{1,M} \\ 
                   X_{2,1} & X_{2,2} & \cdots & X_{2,M} \\ 
                   \vdots & \vdots &  & \vdots \\ 
                   X_{T,1} & X_{T,2} & \cdots & X_{T,M} \\ 
                 \end{array} \right) 
                 \longrightarrow
                 \left(
                 \begin{array}{cccc} 
                   N_{1,1} & N_{1,2} & \cdots & N_{1,M} \\ 
                   N_{2,1} & N_{2,2} & \cdots & N_{2,M} \\ 
                   \vdots & \vdots &  & \vdots \\ 
                   N_{T,1} & N_{T,2} & \cdots & N_{T,M} \\ 
                 \end{array} \right)}
  and
  \deqn{\code{Nmean.record}: \code{X} 
        \longrightarrow
        \big( \bar{N}_1, \bar{N}_2, \cdots, \bar{N}_T \big).}
        
  Number and mean number of records for both upper and lower records can be 
  calculated.
}
\note{
If \code{X} is a vector both functions return the same values, 
  \code{N.record} as a matrix and \code{Nmean.record} as a vector.
}
\examples{
Y1 <- c( 1,  5,  3,  6,  6,  9,  2)
Y2 <- c(10,  5,  3,  6,  6,  9,  2)
Y3 <- c( 5,  7,  3,  6, 19,  2, 20)
Y  <- cbind(Y1, Y2, Y3)

N.record(Y)
Nmean.record(Y)

N.record(ZaragozaSeries)
Nmean.record(ZaragozaSeries, record = 'l')

}
\references{
Arnold BC, Balakrishnan N, Nagaraja HN (1998). 
\emph{Records}. 
Wiley Series in Probability and Statistics. Wiley, New York.
\doi{10.1002/9781118150412}.
}
\seealso{
\code{\link{I.record}}, \code{\link{L.record}}, 
  \code{\link{p.record}}, \code{\link{R.record}},
  \code{\link{records}}, \code{\link{S.record}}
}
\author{
Jorge Castillo-Mateo
}
