% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dynamics.R
\name{Michaelis.Menten}
\alias{Michaelis.Menten}
\title{Michaelis-Menten equations}
\usage{
Michaelis.Menten(t, x, params)
}
\arguments{
\item{t}{Current time}

\item{x}{Current value of all nodes}

\item{params}{List of parameters. Should include the adjacency matrix of the network `M`, and parameters `f, h,` and `B`}
}
\value{
A list with `dx`
}
\description{
The standard Michaelis-Menten equations
}
\examples{
\donttest{
   node_file <- system.file("extdata", "IL17.nodes.csv", package = "Rato")
   edge_file <- system.file("extdata", "IL17.edges.csv", package = "Rato")
   g <- Rato::graph.from.csv(node_file, edge_file, sep=",", header=TRUE)
 
   Rato::node.removal.thread(  Rato::Michaelis.Menten
                             , g$M
                             , g$initial_values
                             , initial_params = list('f' = 1, 'h'=2, 'B'=0.1))

}
}
