% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_inout_simultaneity.R
\name{analyze_in_out_simultaneity}
\alias{analyze_in_out_simultaneity}
\title{Analyze relationships between rare events among multiple input and output variables}
\usage{
analyze_in_out_simultaneity(boolean_input_mult_df, combo_length, min_output_count,
                            max_output_count, min_indv_threshold, max_freq_threshold,
                            input_format, output_format, pval_filter_threshold,
                            adj_pval_type)
}
\arguments{
\item{boolean_input_mult_df}{An input Boolean dataframe with multiple input and outcome variables}

\item{combo_length}{The length of the combinations specified by the user}

\item{min_output_count}{Minimum number of output variables present in the combination}

\item{max_output_count}{Maximum number of output variables present in the combination}

\item{min_indv_threshold}{Minimum number of instances that support the combination}

\item{max_freq_threshold}{Maximum fraction of the cohort size that could support a combination (i.e., filter out highly frequent events)}

\item{input_format}{Optional | Naming convention used for input variables (Default = 'Input_')}

\item{output_format}{Optional | Naming convention used for output variables (Default = 'Output_')}

\item{pval_filter_threshold}{Optional | p-value cut-off to use to identify significant combinations (Default = 0.05)}

\item{adj_pval_type}{Optional | Type of multiple testing corrections to use (Default = 'BH'; Alternative option = 'bonferroni')}
}
\value{
A dataframe with the list of multiple-testing adjusted statistically significant combinations
        along with quantitative measures (frequencies, p-values etc) that support the findings.
}
\description{
This function takes a Boolean dataframe as input and analyzes the
relationship between input and output variables for the combinations
that that include at least a single output variable andmeet all the
input criteria specified by the user.
}
\examples{
    analyze_in_out_simultaneity(boolean_input_mult_df, 3, 1, 2, 5, 0.25,
                                input_format = 'Input_', output_format = 'Output_',
                                pval_filter_threshold = 0.05, adj_pval_type = 'BH')


}
\author{
Vijay Kumar Pounraja
}
