% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{prefix_normalized_distance}
\alias{prefix_normalized_distance}
\title{Calculate the normalized prefix distance between two strings}
\usage{
prefix_normalized_distance(s1, s2, score_cutoff = 1)
}
\arguments{
\item{s1}{A string. The first input string.}

\item{s2}{A string. The second input string.}

\item{score_cutoff}{An optional maximum threshold for the normalized distance. Defaults to 1.0.}
}
\value{
The normalized prefix distance as a double.
}
\description{
Computes the normalized distance of the prefixes of two strings, where the result is between
0.0 (identical) and 1.0 (completely different).
}
\examples{
prefix_normalized_distance("abcdef", "abcxyz")
prefix_normalized_distance("abcdef", "abcxyz", score_cutoff = 0.5)
}
