## Radial Visualization Shiny Gadgets


The following package creates a RShiny Gadgets for Radial Visualizations.


## Star Coordinates 

The original Star Coordinates as proposed by Kandogan [1] along with optional axis calibration [3]. As the original approach is based on solely numerical attributes, an extension to hybrid representation can be applied [4]. 

Other extensions for the approach are implemented. Hints [4]  and Orthographic Star Coordinates [2].

## RadViz

An implementation of the traditional RadViz as presented in [5]. 

## Installation


You can install the stable version from the main branch:

    devtools::install_github(repo = "jmatute/RadialShinyGadgets", ref="main")


## Usage 

See the radial package vignettes for more details or go to [my website](https://www.jmatute.de/RadVisGadget)
    
    library(RadialVisGadgets)
    
## License

This package is free and open source software, licensed under [MIT licence](https://opensource.org/licenses/MIT)

## References 


1. Kandogan, E. (2001, August). Visualizing multi-dimensional clusters, trends, and outliers using star coordinates. In Proceedings of the seventh ACM SIGKDD international conference on Knowledge discovery and data mining (pp. 107-116).

2. Lehmann, D. J., & Theisel, H. (2013). Orthographic star coordinates. IEEE Transactions on Visualization and Computer Graphics, 19(12), 2615-2624.

3. Rubio-Sánchez, M., & Sanchez, A. (2014). Axis calibration for improving data attribute estimation in star coordinates plots. IEEE transactions on visualization and computer graphics, 20(12), 2013-2022

4. Matute, J., & Linsen, L. (2020, February). Hinted Star Coordinates for Mixed Data. In Computer Graphics Forum (Vol. 39, No. 1, pp. 117-133).

5. Sharko, J., Grinstein, G., & Marx, K. A. (2008). Vectorized radviz and its application to multiple cluster datasets. IEEE transactions on Visualization and Computer Graphics, 14(6), 1444-1427.


