% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirichlet.R
\name{dirichlet}
\alias{dirichlet}
\alias{ddirichlet}
\alias{rdirichlet}
\title{Dirichlet distribution}
\usage{
ddirichlet(x, alpha, log = FALSE)

rdirichlet(n, alpha)
}
\arguments{
\item{x}{vector or matrix of quantiles. If \code{x} is a vector, it needs to sum to one.
If \code{x} is a matrix, each row should sum to one.}

\item{alpha}{vector or matrix of positive shape parameters}

\item{log}{logical; if \code{TRUE}, densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{n}{number of random values to return.}
}
\value{
\code{ddirichlet} gives the density, \code{rdirichlet} generates random deviates.
}
\description{
Density and and random generation for the Dirichlet distribution.
}
\details{
This implementation of \code{ddirichlet} allows for automatic differentiation with \code{RTMB}.
}
\examples{
# single alpha
alpha <- c(1,2,3)
x <- rdirichlet(1, alpha)
d <- ddirichlet(x, alpha)
# vectorised over alpha
alpha <- rbind(alpha, 2*alpha)
x <- rdirichlet(2, alpha)
}
