% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trunct2.R
\name{trunct2}
\alias{trunct2}
\alias{dtrunct2}
\alias{ptrunct2}
\alias{qtrunct2}
\alias{rtrunct2}
\title{Truncated t distribution with location and scale}
\usage{
dtrunct2(x, df, mu = 0, sigma = 1, min = -Inf, max = Inf, log = FALSE)

ptrunct2(q, df, mu = 0, sigma = 1, min = -Inf, max = Inf,
         lower.tail = TRUE, log.p = FALSE)

qtrunct2(p, df, mu = 0, sigma = 1, min = -Inf, max = Inf,
         lower.tail = TRUE, log.p = FALSE)

rtrunct2(n, df, mu = 0, sigma = 1, min = -Inf, max = Inf)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{df}{degrees of freedom parameter, must be positive.}

\item{mu}{location parameter.}

\item{sigma}{scale parameter, must be positive.}

\item{min, max}{truncation bounds.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of random values to return.}
}
\value{
\code{dtrunct2} gives the density, \code{ptrunct2} gives the distribution function,
\code{qtrunct2} gives the quantile function, and \code{rtrunct2} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation for
the truncated t distribution with location \code{mu} and scale \code{sigma}.
}
\details{
This implementation of \code{dtrunct2} allows for automatic differentiation with \code{RTMB}.
}
\examples{
x <- rtrunct2(1, df = 5, mu = 2, sigma = 3, min = -1, max = 5)
d <- dtrunct2(x, df = 5, mu = 2, sigma = 3, min = -1, max = 5)
p <- ptrunct2(x, df = 5, mu = 2, sigma = 3, min = -1, max = 5)
q <- qtrunct2(p, df = 5, mu = 2, sigma = 3, min = -1, max = 5)
}
