% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RsquareMI.R
\name{RsquareSP}
\alias{RsquareSP}
\title{Calculate R-squared with Standardized Predictors}
\usage{
RsquareSP(
  object,
  cor = FALSE,
  conf = FALSE,
  conf.level = 0.95,
  alternative_adj_R2 = FALSE
)
}
\arguments{
\item{object}{The results of a regression on a multiply imputed dataset of
class `mira` from the `mice` package.}

\item{cor}{Logical. If `TRUE`, the function returns the zero-order
correlations between the outcome and each predictor.}

\item{conf}{Logical. If `TRUE`, the function returns the confidence intervals
of the standardized regression coefficients.}

\item{conf.level}{A real number between 0 and 1 specifying the confidence level
of the confidence intervals.}

\item{alternative_adj_R2}{Logical. If `TRUE`, the function returns alternative
estimates of adjusted R^2, as described in the references}
}
\value{
A list of class `RsquaredMI` containing the following elements:
\item{r_squared}{The R-squared value calculated using standardized predictors.}
\item{r}{The square root of the R-squared value, or the multiple correlation R.}
\item{rtotal}{A vector containing both the R-squared and R.}
\item{beta}{The standardized regression coefficients.}
\item{lower}{The lowerbound of the condidence intervals of the standardized
regression coefficients  (if `conf = TRUE`).}
\item{upper}{The upperbound of the condidence intervals of the standardized
regression coefficients  (if `conf = TRUE`).}
\item{dfe}{The error degrees of freedom of the condidence intervals of
the standardized regression coefficients  (if `conf = TRUE`).}
\item{zero}{The zero-order correlations between the outcome and each predictor}
\item{total}{A matrix containing the betas and optionally (if `cor = TRUE`), the error degrees of
freedom, confidence intervals, and zero-order correlations.}
}
\description{
This function calculates the R-squared value for a linear model applied to a
multiply imputed dataset, along with standardized regression coefficients.
Optionally, it can also return the confidence intervals of the standardized
regression coefficients and the zero-order correlations.
}
\details{
The function first completes the imputed datasets using 'mice::complete'.
It then calculates the linear model on each imputed dataset and averages
the standardized coefficients and correlations across imputations.
The final R-squared value is computed as the sum of the products of the
averaged standardized coefficients and averaged correlations.
The confidence intervals of the standardized regression coefficients are
calculated under the assumption that the variables are multivarate normally
distributed
}
\examples{
library(mice)
imp <- mice(nhanes, print = FALSE, seed = 16117)
fit <- with(imp, lm(chl ~ age + hyp + bmi))
RsquareSP(fit)
}
\references{
Van Ginkel, J.R., & Karch, J.D. (2024). A comparison of different measures of
the proportion of explained variance in multiply imputed data sets.
British Journal of Mathematical and Statistical Psychology. \doi{10.1111/bmsp.12344}

Karch, J.D. (2024). Improving on Adjusted R-squared. Collabra: Psychology. \doi{10.1525/collabra.343}

Van Ginkel, J.R. (2020). Standardized regression coefficients and newly proposed
estimators for R^2 in multiply imputed data. Psychometrika. \doi{10.1007/s11336-020-09696-4}
}
