% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrmultinom.R
\name{rrmultinom}
\alias{rrmultinom}
\title{rrmultinom}
\usage{
rrmultinom(I, z1 = NULL, z2 = NULL, T, R, eps = 1e-05, ref = NULL)
}
\arguments{
\item{I}{a U by U incidence matrix with elements; U is number of states; I(i,j)=1
if state j can be accessed from state i in one step and 0 otherwise}

\item{z1}{a n by p matrix with covariates involved in the dimension reduction(DR),
n is the number of subjects, p is the number of covariates involved in DR}

\item{z2}{a n by q matrix with study covariates (not in dimension reduction),
q is the number of study covariates}

\item{T}{a M by 3 state matrix,
\itemize{
\item the first column is a subject number between 1,..,n;
\item the second column is time;
\item the third column is the state occupied by subject in column 1 at time indicated
    in column 2
}}

\item{R}{the rank}

\item{eps}{the tolerance for convergence; the default is 10^-5}

\item{ref}{a vector of reference categories; the default is NULL and if NULL
is used, the function will use the first category as the reference category
for each row}
}
\value{
a list of outputs:
\itemize{
\item Alpha: the final A matrix
\item Gamma: the final G matrix
\item Beta: the coefficient matrix for variables involved in reduced rank
\item Dcoe: the coefficient matrix for the fixed variables
\item Dsderr: the standard error matrix for the fixed variables
\item Dpval: the p-value matrix for the fixed variables
\item coemat: the overall coefficient matrix
\item niter: the iteration number to get converged
\item df: the degrees of freedom
\item loglik: the final loglikelihood
\item converge: three possible values with 0 means fail to converge, 1 means
    converges, and 2 means the maximum iteration is achieved
}
}
\description{
This function is used to fit the reduced rank multinomial logistic regression
    for markov chain
}
\examples{
# generate the Markov chain
U=7
I1=I2=I3=rep(1,7)
I4=c(0,0,0,1,1,1,1)
I5=I6=I7=rep(0,7)
I=rbind(I1,I2,I3,I4,I5,I6,I7)
# prepare the data
data=cogdat
n=length(unique(data[,1]))
M=nrow(data)+n
Mc=0
z=matrix(0,n,9)
colnames(z)=colnames(data)[5:13]
T=matrix(0,M,3)
for(i in 1:n){
 subdat=data[which(data[,1]==i),,drop=FALSE]
 z[i,]=subdat[1,5:13]
 mc=nrow(subdat)
 T[(Mc+1):(Mc+mc+1),1]=i
 T[(Mc+1):(Mc+mc+1),2]=0:mc
 T[(Mc+1):(Mc+mc+1),3]=c(subdat[1,3],subdat[,4])
 Mc=Mc+mc+1
}
#z1=z[,c(1:3),drop=FALSE]
z2=z[,4,drop=FALSE]
# fit the model with rank 1
rrmultinom(I,z1=NULL,z2,T,1,eps=9,ref=c(1,1,1,4))

}
