% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbAppendTableAs.R
\name{dbAppendTableAs}
\alias{dbAppendTableAs}
\title{Append to a table in database using a statement}
\usage{
dbAppendTableAs(conn, name, sql, auto_reorder = TRUE, ...)
}
\arguments{
\item{conn}{a \code{PrestoConnection} object, as returned by \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{DBI::dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{DBI::Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{DBI::SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{sql}{a character string containing SQL statement, or a \code{tbl_presto} object.}

\item{auto_reorder}{Logical (default \code{TRUE}). If \code{TRUE}, automatically reorders
query columns to match table column order when column names match but order
differs. If \code{FALSE}, columns are inserted in query order.}

\item{...}{Other arguments used by individual methods.}
}
\description{
Append to a table in database using a statement
}
