% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROKET.R
\name{run_myOT}
\alias{run_myOT}
\title{run_myOT}
\usage{
run_myOT(
  XX,
  YY,
  COST,
  EPS,
  LAMBDA1,
  LAMBDA2 = NULL,
  balance = FALSE,
  conv = 1e-05,
  max_iter = 3000,
  verbose = TRUE,
  show_iter = 50
)
}
\arguments{
\item{XX}{A numeric vector of positive masses}

\item{YY}{A numeric vector of positive masses}

\item{COST}{A numeric matrix of non-negative values
representing the costs to transport masses between
features of \code{XX} and \code{YY}. The rows of \code{COST}
and features of \code{XX} need to be aligned.
The columns of \code{COST} and features of \code{YY}
need to be aligned.}

\item{EPS}{A positive numeric value representing the
tuning parameter for entropic regularization.}

\item{LAMBDA1}{A non-negative numeric value representing
the tuning parameter penalizing the distance between \code{XX}
and the row sums of the optimal transport matrix.}

\item{LAMBDA2}{A non-negative numeric value representing
the tuning parameter penalizing the distance between \code{YY}
and the column sums of the optimal transport matrix.}

\item{balance}{Boolean set to \code{TRUE} to run balanced
optimal transport regardless of LAMDA1 and LAMBDA2. 
Otherwise run unbalanced optimal transport.}

\item{conv}{A positive numeric value to determine 
algorithmic convergence. The default value is \code{1e-5}.}

\item{max_iter}{A positive integer denoting the maximum
iterations to run the algorithm.}

\item{verbose}{Boolean value to display verbose function output.}

\item{show_iter}{A positive integer to display iteration details
at multiples of \code{show_iter} but only if \code{verbose = TRUE}.}
}
\value{
A R list containing the optimal transport matrix and 
associated distance metric.
}
\description{
Runs balanced or unbalanced optimal transport
on two input vectors
}
