% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbox.R
\name{ggboxplot}
\alias{ggboxplot}
\title{Plot the Box Figure}
\usage{
ggboxplot(data, mapping)
}
\arguments{
\item{data}{a tibble}

\item{mapping}{the mapping parameter of ggplot}
}
\value{
A box figure by ggplot
}
\description{
Plot the box figure beautifully with ggplot.
}
\examples{
names <- c("swan", "bear", "tiger")
date <- as.Date("2015-01-01") + days(0:179)
mu <- c(0.2, 0.08, 0.1)
sigma <- matrix(c(1, 0.25, -0.3, 0.25, 0.25, 0, -0.3, 0, 0.36), 3, 3)
allret <- rMvReturnSim(names, date, mu, sigma)
totret <- StackRet(allret, date)
ggboxplot(totret, aes(x = stock, y = ret))
}
