% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mode_impute.R
\name{mode_impute}
\alias{mode_impute}
\title{Mode imputation}
\usage{
mode_impute(X, values = NULL)
}
\arguments{
\item{X}{a matrix or data frame of discrete data with missing values.}

\item{values}{an optional numeric vector giving the possible values.
Currently, the possible values are assumed to be the same for all columns.  
If \code{NULL}, the unique values of the observed parts of \code{X} are 
used.}
}
\value{
An object of class \code{"mode_impute"} with the following components: 
\item{modes}{a list containing the mode(s) of the observed values 
for each variable.}
\item{X}{a numeric matrix containing the completed (i.e., imputed) data 
matrix.}

The class structure is still experimental and may change in the future. 
Use the accessor function \code{\link{get_completed}()} to extract the 
completed (i.e., imputed) data matrix.
}
\description{
Perform mode imputation for discrete data.  In case of multiple modes in a 
given column, one of them is selected at random for each missing cell.
}
\note{
The mode is computed as the most frequent value, hence this function is only 
suitable for discrete data.  It does not estimate the mode of a continuous 
density.
}
\examples{
# toy example derived from MovieLens 100K dataset
data("MovieLensToy")
# mode imputation
fit <- mode_impute(MovieLensToy, values = 1:5)
# extract completed matrix
X_hat <- get_completed(fit)
head(X_hat)

}
\seealso{
\code{\link{median_impute}()}
}
\author{
Andreas Alfons
}
\keyword{multivariate}
