% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPOTIS.R
\name{generate.SPOTIS.bounds}
\alias{generate.SPOTIS.bounds}
\title{Generate bounds for criteria from a decision matrix}
\usage{
generate.SPOTIS.bounds(matrix)
}
\arguments{
\item{matrix}{A numeric matrix or data frame where rows represent alternatives and columns represent criteria.}
}
\value{
A numeric matrix with two columns: minimum and maximum bounds for each criterion.
}
\description{
Generate bounds for criteria from a decision matrix
}
\examples{
# Decision matrix
matrix <- matrix(c(96, 145, 200,
                   100, 145, 200,
                   120, 170, 80,
                   140, 180, 140,
                   100, 110, 30), nrow = 5, byrow = TRUE)

# Generate bounds
bounds <- generate.SPOTIS.bounds(matrix)

}
