% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORESTE.R
\name{apply.ORESTE}
\alias{apply.ORESTE}
\title{Apply the ORESTE (Organisation Rangement Et SynThèsE de données relationnelles) Method}
\usage{
apply.ORESTE(mat, weights, beneficial.vector, alpha = 0.4)
}
\arguments{
\item{mat}{A numeric matrix with each row representing an alternative and each column a criterion.}

\item{weights}{A numeric vector of weights for each criterion (same length as number of columns).}

\item{beneficial.vector}{An integer vector of column indices specifying which criteria are "max" (beneficial).}

\item{alpha}{A numeric parameter controlling the relative weight of data-based and weight-based ranks.}
}
\value{
A numeric vector of ORESTE scores (summed ranks) for each alternative.
}
\description{
Criteria with indexes in
beneficial.vector are interpreted as beneficial (maximize), whereas
others are cost-type (minimize). Rankings are performed for both the data
matrix and the weights, then combined in the ORESTE manner.
}
\examples{
mat <- matrix(c(10, 2,
                20, 4,
                15, 5),
              nrow = 3, byrow = TRUE)
weights <- c(0.7, 0.3)
beneficial.vector <- c(1)   # 1st column "max", 2nd column "min"

apply.ORESTE(mat, weights, beneficial.vector, alpha = 0.4)

}
