% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrices.R
\name{RME_stoch}
\alias{RME_stoch}
\title{Generate an ensemble of stochastic matrices}
\usage{
RME_stoch(N, ..., size)
}
\arguments{
\item{N}{number of dimensions of the square matrix}

\item{...}{pass any default-valued parameters taken as arguments by RM_stoch()}

\item{size}{the size of the ensemble (i.e. number of matrices)}
}
\value{
An ensemble (list) of stochastic matrices as specified by the matrix arguments.
}
\description{
Given the same arguments as RM_stoch, this function returns an ensemble of random stochastic matrices.
  While random matrices usually do not exude unique properties on their own, they do indeed have
  deterministic properties at the ensemble level in terms of their spectral statistics.
}
\examples{
# Generate an ensemble of random 5x5 transition matrices of size 20.
ensemble <- RME_stoch(N = 5, size = 20)

# Generate an ensemble of symmetric random 5x5 transition matrices of size 20.
ensemble <- RME_stoch(N = 5, symm = TRUE, size = 20)

}
