% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_jdate_options.R
\name{jdopt_set_default_separator}
\alias{jdopt_set_default_separator}
\title{Specify the default separator}
\usage{
jdopt_set_default_separator(separator)
}
\arguments{
\item{separator}{character}
}
\value{
options list that includes DEFAULT_SEPARATOR, VALID_SEPARATORS, MIN_YEAR, MAX_YEAR
}
\description{
specifying one of valid separators as default separator
}
\details{
The default separator (where initially is "/") has several uses.
For example, to print JalaliDate: JalaliDate(list(1375, 1, 2)) that display
"1375/01/02". Selected separator must belong to 'VALID_SEPARATORS' set, otherwise
an error would be raised.
}
\examples{
JalaliDate(Sys.Date())
# [1] "1403/04/29"
jdopt_set_default_separator("-")
JalaliDate(Sys.Date())
# [1] "1403-04-29"

}
