% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_matrix_kernels.R
\name{SparseQrMicrobenchmark}
\alias{SparseQrMicrobenchmark}
\title{Conducts a single performance trial with the QR factorization sparse matrix
kernel}
\usage{
SparseQrMicrobenchmark(benchmarkParameters, kernelParameters)
}
\arguments{
\item{benchmarkParameters}{an object of type
\code{\link{SparseMatrixMicrobenchmark}} specifying various parameters
for microbenchmarking the sparse matrix kernel}

\item{kernelParameters}{a list of matrices or vectors to be used as input to
the sparse matrix kernel}
}
\description{
\code{SparseQrVectorMicrobenchmark} conducts a single performance trial
of the QR factorization sparse matrix kernel for the matrix given
in the \code{kernelParameters} parameter.  The function times the single
function call \code{qr(kernelParameters$A)}.
}
\examples{
\dontrun{
# Allocate input to the QR factorization microbenchmark for the
# Maragal_6 matrix
microbenchmarks <- GetSparseQrDefaultMicrobenchmarks()
kernelParameters <- SparseQrAllocator(microbenchmarks[["qr_Maragal_6"]], 1)
# Execute the microbenchmark
timings <- SparseQrMicrobenchmark(
   microbenchmarks[["qr_Maragal_6"]], kernelParameters)
}

}
