% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_space.R
\name{.updateSSSystem}
\alias{.updateSSSystem}
\title{Updates the system matrices of an object of class \code{NAWRUmodel} or \code{TFPmodel}
during optimization or during a Bayesian Gibbs procedure.}
\usage{
.updateSSSystem(
  pars,
  SSModel,
  loc,
  cycle,
  trend,
  errorARMA,
  signalToNoise = NULL,
  type = NULL,
  bayes = FALSE
)
}
\arguments{
\item{pars}{A vector of parameters.}

\item{SSModel}{An object of class \code{SSModel} specifying the state-space model.}

\item{loc}{A data frame containing information on each involved parameter, for instance
its corresponding system matrix, variable names, and parameter restrictions.}

\item{cycle}{A character string specifying the cycle model. \code{cycle = "AR1"} denotes
an AR(1) process, \code{cycle = "AR2"} an \code{AR(2)} process. The default is
\code{cycle = "AR2"}.}

\item{trend}{A character string specifying the trend model. \code{trend = "RW1"} denotes
a first order random walk, \code{trend = "RW2"} a second order random walk (local linear
trend) and \code{trend = "DT"} a damped trend model. The default is \code{trend = "RW2"}.}

\item{errorARMA}{A vector with non-negative integers specifying the AR
and MA degree of the error term in the second observation equation.}

\item{signalToNoise}{(Optional) signal to noise ratio. Only used if \code{method = "MLE"}.}

\item{type}{A character string specifying the type of the Phillip's curve.
\code{type = "TKP"} denotes the traditional Keynesian Phillip's curve and
\code{type = "NKP"} the New Keynesian Phillip's curve, see details. The default is
\code{type = "TKP"}.}

\item{bayes}{A logical indicating whether the update is part of a Bayesian procedure, i.e.,
the parameter constraints do not need to be enforced.}
}
\description{
Updates the system matrices of an object of class \code{NAWRUmodel} or \code{TFPmodel}
during optimization or during a Bayesian Gibbs procedure.
}
\keyword{internal}
