% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{.checkNawru}
\alias{.checkNawru}
\title{Checks the input variables for the procedure \code{NAWRUmodel} for consistency and
validity.}
\usage{
.checkNawru(
  tsl,
  trend,
  cycle,
  type,
  cycleLag,
  errorARMA,
  exoNames,
  exoType,
  start,
  end,
  anchor,
  anchor.h
)
}
\arguments{
\item{tsl}{A list of time series objects, see details.}

\item{trend}{A character string specifying the trend model. \code{trend = "RW1"} denotes
a first order random walk, \code{trend = "RW2"} a second order random walk (local linear
trend) and \code{trend = "DT"} a damped trend model. The default is \code{trend = "RW2"}.}

\item{cycle}{A character string specifying the cycle model. \code{cycle = "AR1"} denotes
an AR(1) process, \code{cycle = "AR2"} an \code{AR(2)} process. The default is
\code{cycle = "AR2"}.}

\item{type}{A character string specifying the type of the Phillip's curve.
\code{type = "TKP"} denotes the traditional Keynesian Phillip's curve and
\code{type = "NKP"} the New Keynesian Phillip's curve, see details. The default is
\code{type = "TKP"}.}

\item{cycleLag}{A vector specifying the cycle lags that are included in the Phillip's
curve. The default is \code{cycleLag = 0}, see details.}

\item{errorARMA}{A vector with non-negative integers specifying the AR
and MA degree of the error term in the Phillip's curve equation.}

\item{exoNames}{A character vector containing the names of the exogenous variables.}

\item{exoType}{An optional \code{n x m x 2} array specifying the possible difference
and lag transformation for the variables. \code{exoType} can be initialized using the
function \code{inizializeExo}. The column names give the variable names.
\code{exoType[, , 1]} contains the difference transformations and \code{exoType[, , 2]}
the subsequent lag transformations, see details.}

\item{start}{(Optional) Start vector for the estimation, e.g. \code{c(1980, 1)}.}

\item{end}{(Optional) End vector for the estimation, e.g. \code{c(2020, 1)}.}

\item{anchor}{(Optional) Anchor value for the unemployment rate.}

\item{anchor.h}{(Optional) Anchor horizon in the frequency of the given time series.}
}
\description{
Checks the input variables for the procedure \code{NAWRUmodel} for consistency and
validity.
}
\keyword{internal}
