% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_export.R
\name{rd_export}
\alias{rd_export}
\title{Export Queries to an Excel File}
\usage{
rd_export(
  project = NULL,
  queries = NULL,
  column = NULL,
  sheet_name = NULL,
  path = NULL,
  password = NULL
)
}
\arguments{
\item{project}{A list containing the dataframe of queries and results (expected \code{rd_query} or \code{rd_event} output). Overrides \code{queries}.}

\item{queries}{A data frame of identified queries.}

\item{column}{Name of the column containing URLs to convert into hyperlinks. If \code{NULL}, hyperlinks are added only if a \code{Link} column exists.}

\item{sheet_name}{Name of the Excel sheet in the resulting \code{.xlsx} file. Default: \code{"Sheet1"}.}

\item{path}{File path for saving the \code{.xlsx} file. If \code{NULL}, the file is saved as \code{"example.xlsx"} in the working directory.}

\item{password}{Optional password to protect the worksheet from edits.}
}
\value{
An \code{.xlsx} file written to the specified path.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Export a query dataset (e.g., from \code{rd_query} or \code{rd_event}) to an \code{.xlsx} file. The function can optionally convert a column of URLs into Excel hyperlinks and apply password protection to the worksheet.
}
\examples{
\dontrun{
rd_export(
  queries = my_queries,
  column = "Link",
  sheet_name = "My Queries",
  path = "queries.xlsx"
)
}

}
